import 'package:carousel_slider/carousel_slider.dart';
import 'package:flutter/material.dart';
import 'package:flutter_riverpod/flutter_riverpod.dart';
import 'package:gap/gap.dart';
import 'package:razinsoft_rider/common/loading_view.dart';
import 'package:razinsoft_rider/core/utils/network_image.dart';
import 'package:razinsoft_rider/data/models/promotional_slider_model/promotional_slider_model.dart';
import 'package:razinsoft_rider/presentation/dashboard/provider/promotional_slider_provider.dart';
import 'package:smooth_page_indicator/smooth_page_indicator.dart';
import '../../../core/theme/color_palette.dart';
import '../../account_page/provider/theme_provider.dart';

class PromotionalSlider extends ConsumerStatefulWidget {
  const PromotionalSlider({super.key});

  @override
  ConsumerState<PromotionalSlider> createState() => _PromotionalSliderState();
}

class _PromotionalSliderState extends ConsumerState<PromotionalSlider> {
  int _activeIndex = 0;

  bool isDark()=> ref.read(themeModeProvider.notifier).isDarkMode();
  @override
  Widget build(BuildContext context) {
    final state = ref.watch(promotionalSliderProvider);
    final showNothing = state.whenOrNull(error: (e)=> true, success: (data)=> data.isEmpty) ?? false;
    if(showNothing){
      return const SizedBox.shrink();
    }
    return Container(
      color: isDark() ? Colors.black : ColorPalette.neutralF6,
      padding: const EdgeInsets.symmetric(vertical: 16),
      child: state.when(initial: ()=> const SizedBox.shrink(), loading: ()=> const LoadingView(), success: (list){
        if(list.isEmpty){
          return const SizedBox.shrink();
        }
        return Column(
          mainAxisSize: MainAxisSize.min,
          children: [
            CarouselSlider.builder(
              itemCount: list.length,
              itemBuilder: (context, index, realIndex) {
                final Promotions promotion = list[index];
                return ClipRRect(
                    borderRadius: BorderRadius.circular(16),
                    child: buildNetworkImage(imageUrl: promotion.image, height: 160, width: double.infinity, fit: BoxFit.fill));
              },
              options: CarouselOptions(
                height: 160,
                autoPlay: true,
                enlargeCenterPage: true,
                onPageChanged: (index, reason) {
                  setState(() => _activeIndex = index);
                },
              ),
            ),
            const Gap(8),
            AnimatedSmoothIndicator(
              activeIndex: _activeIndex,
              count: list.length,
              duration: const Duration(milliseconds: 500),
              effect: const ExpandingDotsEffect(
                dotHeight: 8,
                dotWidth: 8,
                expansionFactor: 2.5,
                radius: 50,
                dotColor: ColorPalette.neutral70,
                activeDotColor: ColorPalette.primary50,
              ),

            ),
          ],
        );
      }, error: (e)=> const SizedBox.shrink())
    );
  }
}
